/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client.model.baked.bit;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import mod.chiselsandbits.api.blockinformation.BlockInformation;
import mod.chiselsandbits.api.item.bit.IBitItem;
import mod.chiselsandbits.api.variant.state.IStateVariantManager;
import mod.chiselsandbits.client.model.baked.bit.BitBlockBakedModel;
import mod.chiselsandbits.client.model.baked.simple.NullBakedModel;
import mod.chiselsandbits.client.time.TickHandler;
import mod.chiselsandbits.registrars.ModItems;
import net.minecraft.class_1087;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2404;
import net.minecraft.class_310;
import net.minecraft.class_437;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BitBlockBakedModelManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final BitBlockBakedModelManager INSTANCE = new BitBlockBakedModelManager();
    private final Cache<BlockInformation, class_1087> modelCache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build();
    private final Cache<BlockInformation, class_1087> largeModelCache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build();
    private final class_2371<class_1799> alternativeStacks = class_2371.method_10211();

    private BitBlockBakedModelManager() {
    }

    public static BitBlockBakedModelManager getInstance() {
        return INSTANCE;
    }

    public void clearCache() {
        this.modelCache.asMap().clear();
        this.largeModelCache.asMap().clear();
    }

    public class_1087 get(class_1799 stack, class_1937 world, class_1309 entity) {
        return this.get(stack, world, entity, !class_310.method_1551().field_1690.field_1832.method_1415() && class_310.method_1551().field_1690.field_1832.method_1434() || class_310.method_1551().method_22683() != null && class_437.method_25442());
    }

    public class_1087 get(class_1799 stack, class_1937 world, class_1309 entity, boolean large) {
        if (!(stack.method_7909() instanceof IBitItem)) {
            LOGGER.warn("Tried to get bit item model for non bit item");
            return NullBakedModel.instance;
        }
        class_1087 model = this.get(large, ((IBitItem)stack.method_7909()).getBlockInformation(stack), world, entity);
        return model.method_4710().method_3495(model, stack, null, null, 0);
    }

    public class_1087 get(boolean large, BlockInformation blockInformation, class_1937 level, class_1309 entity) {
        if (blockInformation.isAir() || blockInformation == null) {
            int alternativeIndex;
            class_1799 alternativeStack;
            if (this.alternativeStacks.isEmpty()) {
                ModItems.ITEM_BLOCK_BIT.get().method_7850(Objects.requireNonNull(ModItems.ITEM_BLOCK_BIT.get().method_7859()), this.alternativeStacks);
            }
            if (!((alternativeStack = (class_1799)this.alternativeStacks.get(alternativeIndex = (int)(Math.floor((double)TickHandler.getClientTicks() / 20.0) % (double)this.alternativeStacks.size()))).method_7909() instanceof IBitItem)) {
                throw new IllegalStateException("BitItem returned none bit item stack!");
            }
            blockInformation = ((IBitItem)alternativeStack.method_7909()).getBlockInformation(alternativeStack);
        }
        Cache<BlockInformation, class_1087> target = large ? this.largeModelCache : this.modelCache;
        BlockInformation workingState = blockInformation;
        try {
            return (class_1087)target.get((Object)blockInformation, () -> {
                if (large) {
                    class_1799 lookupStack = IStateVariantManager.getInstance().getItemStack(workingState).orElseGet(() -> new class_1799((class_1935)workingState.getBlockState().method_26204()));
                    if (workingState.getBlockState().method_26204() instanceof class_2404) {
                        lookupStack = new class_1799((class_1935)workingState.getBlockState().method_26227().method_15772().method_15774());
                    }
                    return class_310.method_1551().method_1480().method_4019(lookupStack, level, entity, 0);
                }
                return new BitBlockBakedModel(workingState);
            });
        }
        catch (ExecutionException e) {
            LOGGER.warn("Failed to get a model for a bit: " + blockInformation + " the model calculation got aborted.", (Throwable)e);
            return NullBakedModel.instance;
        }
    }
}

